/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.api.util;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import xfacthd.framedblocks.api.util.client.ClientUtils;

public final class Utils {
    public static final TagKey<Block> FRAMEABLE = Utils.blockTag("frameable");
    public static final TagKey<Block> BLACKLIST = Utils.blockTag("blacklisted");
    public static final TagKey<Item> WRENCH = Utils.itemTag("forge", "tools/wrench");
    public static final TagKey<Item> DISABLE_INTANGIBLE = Utils.itemTag("disable_intangible");
    public static final RegistryObject<Item> FRAMED_HAMMER = RegistryObject.create((ResourceLocation)new ResourceLocation("framedblocks", "framed_hammer"), (IForgeRegistry)ForgeRegistries.ITEMS);
    public static final RegistryObject<Item> FRAMED_KEY = RegistryObject.create((ResourceLocation)new ResourceLocation("framedblocks", "framed_key"), (IForgeRegistry)ForgeRegistries.ITEMS);
    public static final RegistryObject<Item> FRAMED_SCREWDRIVER = RegistryObject.create((ResourceLocation)new ResourceLocation("framedblocks", "framed_screwdriver"), (IForgeRegistry)ForgeRegistries.ITEMS);

    public static VoxelShape rotateShape(Direction from, Direction to, VoxelShape shape) {
        if (Utils.isY(from) || Utils.isY(to)) {
            throw new IllegalArgumentException("Invalid Direction!");
        }
        if (from == to) {
            return shape;
        }
        VoxelShape[] buffer = new VoxelShape[]{shape, Shapes.m_83040_()};
        int times = (to.m_122416_() - from.m_122416_() + 4) % 4;
        for (int i = 0; i < times; ++i) {
            buffer[0].m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = Shapes.m_83110_((VoxelShape)buffer[1], (VoxelShape)Shapes.m_83048_((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX));
            });
            buffer[0] = buffer[1];
            buffer[1] = Shapes.m_83040_();
        }
        return buffer[0];
    }

    public static Vec3 fraction(Vec3 vec) {
        return new Vec3(vec.m_7096_() - Math.floor(vec.m_7096_()), vec.m_7098_() - Math.floor(vec.m_7098_()), vec.m_7094_() - Math.floor(vec.m_7094_()));
    }

    public static double fractionInDir(Vec3 vec, Direction dir) {
        vec = Utils.fraction(vec);
        double coord = switch (dir.m_122434_()) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> vec.f_82479_;
            case Direction.Axis.Y -> vec.f_82480_;
            case Direction.Axis.Z -> vec.f_82481_;
        };
        return Utils.isPositive(dir) ? coord : 1.0 - coord;
    }

    public static boolean isLower(float lhs, float rhs) {
        if (Mth.m_14033_((float)lhs, (float)rhs)) {
            return false;
        }
        return lhs < rhs;
    }

    public static boolean isHigher(float lhs, float rhs) {
        if (Mth.m_14033_((float)lhs, (float)rhs)) {
            return false;
        }
        return lhs > rhs;
    }

    public static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> createBlockEntityTicker(BlockEntityType<A> type, BlockEntityType<E> actualType, BlockEntityTicker<? super E> ticker) {
        return actualType == type ? ticker : null;
    }

    public static TranslatableComponent translate(String prefix, String postfix) {
        return new TranslatableComponent(prefix + ".framedblocks." + postfix);
    }

    public static BlockEntity getBlockEntitySafe(BlockGetter blockGetter, BlockPos pos) {
        if (blockGetter instanceof Level) {
            Level level = (Level)blockGetter;
            return level.m_46745_(pos).m_5685_(pos, LevelChunk.EntityCreationType.CHECK);
        }
        if (blockGetter instanceof LevelChunk) {
            LevelChunk chunk = (LevelChunk)blockGetter;
            return chunk.m_5685_(pos, LevelChunk.EntityCreationType.CHECK);
        }
        if (FMLEnvironment.dist.isClient()) {
            return ClientUtils.getBlockEntitySafe(blockGetter, pos);
        }
        return null;
    }

    public static boolean isPositive(Direction dir) {
        return dir.m_122421_() == Direction.AxisDirection.POSITIVE;
    }

    public static boolean isX(Direction dir) {
        return dir.m_122434_() == Direction.Axis.X;
    }

    public static boolean isY(Direction dir) {
        return dir.m_122434_() == Direction.Axis.Y;
    }

    public static boolean isZ(Direction dir) {
        return dir.m_122434_() == Direction.Axis.Z;
    }

    public static TagKey<Block> blockTag(String name) {
        return Utils.blockTag("framedblocks", name);
    }

    public static TagKey<Block> blockTag(String modid, String name) {
        return BlockTags.create((ResourceLocation)new ResourceLocation(modid, name));
    }

    public static TagKey<Item> itemTag(String name) {
        return Utils.itemTag("framedblocks", name);
    }

    public static TagKey<Item> itemTag(String modid, String name) {
        return ItemTags.create((ResourceLocation)new ResourceLocation(modid, name));
    }

    public static ResourceLocation rl(String path) {
        return new ResourceLocation("framedblocks", path);
    }

    public static MethodHandle unreflectMethod(Class<?> clazz, String srgMethodName, Class<?> ... paramTypes) {
        Method method = ObfuscationReflectionHelper.findMethod(clazz, (String)srgMethodName, (Class[])paramTypes);
        try {
            return MethodHandles.publicLookup().unreflect(method);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Failed to unreflect method '%s#%s()'".formatted(clazz.getName(), srgMethodName), e);
        }
    }

    public static MethodHandle unreflectField(Class<?> clazz, String srgFieldName) {
        Field field = ObfuscationReflectionHelper.findField(clazz, (String)srgFieldName);
        try {
            return MethodHandles.publicLookup().unreflectGetter(field);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Failed to unreflect field '%s#%s'".formatted(clazz.getName(), srgFieldName), e);
        }
    }

    private Utils() {
    }
}

